# Abgabe

Es können CT-Daten im DICOM-Format (z. B. des [Visible-Human Project](https://www.nlm.nih.gov/research/visible/visible_human.html)) eingelesen, und daraus eine 3D-Visualisierung gerendert werden.

# Bauen

Mit CMake. 

Im Projektordner

    mkdir build
    cmake -DCMAKE_BUILD_TYPE=Release -S . -B build/
    cmake --build build/

Die ausführbare Datei liegt danach im Ordner `build/`.

# Nutzung

Die Benutzung und mögliche Parameter lassen sich mithilfe der `--help`-Flag anzeigen.

    Usage: ./Abgabe_Cg_Vis [options] <input>
    
    Program options:
        -h [ --help ]          print help message and exit
        -t [ --threshold ] arg threshold for binarization of cleaning mask (default
                               is 250)
        -b [ --brush ] arg     size of brush for cleaning with morphological
                               operations (default is 25)
        -l [ --lower ] arg     comma separated pair of integer numbers "<row,col>", 
                               for defining region of interest
        -u [ --upper ] arg     comma separated pair of integer numbers "<row,col>", 
                               for defining region of interest

Das positionale `<input>`-Argument muss ein Ordner mit DICOM-Dateien sein, die alphabetisch korrekt sortiert sind.
Die restlichen Argumente sind optional.

## Datenaufbereitung

Werden die entsprechenden Parameter angegeben, findet gegebenenfalls eine Aufbereitung der Daten statt.
Diese Aufbereitung läuft folgendermaßen ab.

1. Aus einer Kopie der Eingangsdaten wird eine Maske generiert.
2. Die Maske wird mit `--threshold` binarisiert.
3. Alle Werte der Maske außerhalb einer mittels `--lower` und `--upper` definierten Region of Interest werden auf `0` gesetzt.
4. Jede Schicht der Maske wird zunächst mit einer Scheibe mit dem Radius `--brush` geöffnet, dann mit 2x `--brush` geschlossen und dilatiert.
5. Die Eingangsdaten werden komponentenweise mit den Daten in der Maske verundet.

Für die Beispieldaten in `female_head` eignen sich Beispielsweise die Parameter `--lower 70,120 --upper 452,380` sehr gut.

## Interaktive Steuerung

Die Animation ist interaktiv und kann gesteuert werden.

- Die Kamera kann mit der Maus per Drag-and-Drop, oder mit dem Kamera-Orientierungs-Widget in der oberen rechten Ecke gesteuert werden.
- Die Transparenz kann mit den Pfeiltasten angepasst werden.
  - Mit <kbd>Up</kbd>/<kbd>Down</kbd> wird die Weite des Trasparenzfensters angepasst.
  - Mit <kbd>Left</kbd>/<kbd>Right</kbd> wird die Mitte des Trasparenzfensters angepasst.
- Mit der <kbd>P</kbd>-Taste kann der **P**rojektionsmodus angepasst werden.
  Zur Auswahl stehen:
  - "Composite"-Modus
  - "Maximum Intensity"-Modus
  - "Iso Surface"-Modus
  - "Additive"-Modus
- Die Kameraperspektive kann mit <kbd>R</kbd> (für **R**eset) zurückgesetzt werden.
- Mit <kbd>Q</kbd> (für **Q**uit), oder durch Schließen des Fensters wird das Programm beendet.

## Legende

In der Legende am unteren Linken Rand werden die folgenden Informationen angezeigt.

- Patientenname,
- Geburtsdatum,
- Geschlecht,
- Aufnahmedatum,
- Mitte des Transparenzfensters,
- Weite des Transparenzfensters und
- momentaner Projektionsmodus.

# Größe

Der Umfang des Projekts, also der Zeilen in allen Header und Source Dateien, mit Kommentaren, aber ohne Leerzeilen.

21.12.2022: 695  
23.12.2022: 872  
25.12.2022: 1018  
26.12.2022: 1012  

Gemessen wurde mit dem Befehl `cat *pp | grep -v '^$' | wc -l` im `src`-Ordner.
Damit sollte ich für die Computergrafik-Abgabe im Rahmen sein.

# Abhängigkeiten

Folgende Bibliotheken werden verwendet:

- [Boost](https://www.boost.org/) v1.78.0
- [OpenGL](https://opengl.org/) v4.6
- [DICOM Toolkit](https://dcmtk.org/) v3.6.7
- [OpenCV](https://opencv.org/) v4.6.0
- [Visualization Toolkit](https://vtk.org/) v9.1.0
- [JsonCPP](https://github.com/open-source-parsers/jsoncpp) v1.9.5

Die Versionsangaben beziehen sich auf die Versionen, die von mir verwendet wurden.
Es kann natürlich durchaus sein, dass auch andere Versionen problemlos funktionieren.

# Beispieldaten

Im Ordner [`data`](data) sind Beispieldaten im DICOM-Format hinterlegt, mit denen die Funktionalität getestet wurde.
Die Daten in `male_head` stammen von der [National Library of Medicine](https://www.nlm.nih.gov/databases/download/vhp.html) und gehören zum oben erwähnten Visible-Human-Project.
Die Daten in `female_head` stammen auch aus dem VHP und von der NLM®, aber wurden von der [University of Iowa](https://medicine.uiowa.edu/mri/facility-resources/images/visible-human-project-ct-datasets) zur Verfügung gestellt.

Dieses Projekt, welches den menschlichen Körper in bisher nicht dagewesener Genauigkeit vermaß und Studis wie mir Zugang zu hochqualitativen Bilddaten verschafft, war nur durch Körperspenden möglich.

Danke "Adam" und danke "Eve".

# Lizenz

Mein Code (alles im `src` Ordner) steht jedem unter der MIT-Lizenz zur Verfügung.
Siehe [LICENSE](LICENSE) für die genauen Lizenzbedingungen.

Sämtliche weiteren Inhalte stehen davon unberührt unter den jeweils für sie relevanten Lizenzbedingungen.

Die Beispieldaten stehen [unter diesen Bedingungen](https://www.nlm.nih.gov/databases/download/terms_and_conditions.html) zur Verfügung.

# Disclaimer

The sample data is provided courtesy of the NLM® and UI Carver College of Medicine, and this project is neither affiliated with, nor endorsed by any of these parties.
